const otp = require('../../models/otp');
const taxcode = require('../../models/taxcode');
const cot = require('../../models/cot');

// Display user admin in
const mongoose = require('mongoose'),
User = mongoose.model('User');

exports.displayAdminSignIn = (req, res) =>{
    res.render('admin/signin')
}

exports.displayAdminSignUp = (req, res) =>{
    res.render('admin/regadmin')
}

// Display admin Dashboard

exports.displayDashboard = (req, res) => {
    if(req.isAuthenticated() && req.user.authtype == 'ADMIN'){
        User.find({authtype: 'OWNER'}).exec(function(err, foundusers){
            if(err){
                catchError(req, res)
            }else{
             res.render('admin/home', {owners: foundusers}) 
            }
        })
    }else{
        res.redirect('/control-auth')
    }
  
    
}


// Display User Profile

exports.displayuserprofile = (req, res) =>{
    if(req.isAuthenticated() && req.user.authtype == 'ADMIN'){
        const userid = req.params.userid;
    User.findOne({_id: userid}).populate(
        {
            path: 'transfertransactions cardtransactions loanrequests'
        }
    ).exec(function(err, founduser){
        if(err){
            catchError(req, res)
        }else{
            //res.send({owner: founduser})
            res.render('admin/profile',{
                owner: founduser,
            })
        }
    })
    }else{
        res.redirect('/control-auth')
    }
    
}

// view edit transaction

exports.view_edit_transaction = (req, res) =>{
    if(req.isAuthenticated() && req.user.authtype == 'ADMIN'){
        const userid = req.params.userid;
    const transactionid = req.params.transactionid;

    User.findOne({_id: userid}, function(err, founduser){
        if(err){
            catchError(req, res)
        }else{
            Transaction.findOne({_id: transactionid}, function(err, foundtransaction){
                if(err){
                    catchError(req, res)
                }else{
                    res.render('admin/edittransaction', {
                        owner: founduser,
                        transaction: foundtransaction
                    })
                }
            })
        }
    })
    }else{
        res.redirect('/control-auth')
    }
    


}

//view edit card transaction


exports.view_edit_cardtransaction = (req, res) =>{
    if(req.isAuthenticated() && req.user.authtype == 'ADMIN'){
        const userid = req.params.userid;
        const cardtransactionid = req.params.cardtransactionid;
    
        User.findOne({_id: userid}, function(err, founduser){
            if(err){
                catchError(req, res)
            }else{
                Cardtransaction.findOne({_id: cardtransactionid}, function(err, foundtransaction){
                    if(err){
                        catchError(req, res)
                    }else{
                        res.render('admin/editcardtransaction', {
                            owner: founduser,
                            transaction: foundtransaction   
                         })
                    }
                })
            }
        })
    
    }else{
        res.redirect('/control-auth')
    }
   

}

// view otp generate

exports.view_otp_generate = (req, res) =>{
    if(req.isAuthenticated() && req.user.authtype == 'ADMIN'){
        otp.find().exec(function(err, foundotps){
            if(err){
                catchError(req, res)
            }else{
                res.render('admin/otp',{
                    otp: foundotps
                })
            }
        })
    }else{
        res.redirect('/control-auth')
    }
   
}

// view otp generate

exports.view_cot_generate = (req, res) =>{
    if(req.isAuthenticated() && req.user.authtype == 'ADMIN'){
        cot.find().exec(function(err, foundcots){
            if(err){
                catchError(req, res)
            }else{
                res.render('admin/cot',{
                    cot: foundcots
                })
            }
        })
    }else{
        res.redirect('/control-auth')
    }
   
}

// view taxcode generate

exports.view_taxcode_generate = (req, res) =>{
    if(req.isAuthenticated() && req.user.authtype == 'ADMIN'){
        taxcode.find().exec(function(err, foundtaxcodes){
            if(err){
                catchError(req, res)
            }else{
                res.render('admin/taxcode',{
                    taxcode: foundtaxcodes
                })
            }
        })
    }else{
        res.redirect('/control-auth')
    }
   
}



// display admin profile

exports.displayprofilemanagement = (req, res) => {
    if(req.isAuthenticated() && req.user.authtype == 'ADMIN'){
        User.findOne({_id: req.user._id}, function(err, founduser){
            if(err){
                catchError(req, res)
            }else{
                res.render('admin/adminprofile',{
                   owner: founduser 
                })
            }
        })
       
    }else{
        res.redirect('/control-auth')
    }
    
}

// VIEW EDIT LOans


exports.view_edit_loans = (req, res) =>{
    if(req.isAuthenticated() && req.user.authtype == 'ADMIN'){
        const userid = req.params.userid;
        const loanid = req.params.loansid;
    
        User.findOne({_id: userid}, function(err, founduser){
            if(err){
                catchError(req, res)
            }else{
               Loans.findOne({_id: loanid}, function(err, foundtransaction){
                    if(err){
                        catchError(req, res)
                    }else{
                        res.render('admin/editloans', {
                            owner: founduser,
                            loan: foundtransaction   
                         })
                    }
                })
            }
        })
    
    }else{
        res.redirect('/control-auth')
    }
   

}